<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Coming Soon</title>
    <link rel="icon" type="image/png" href="images/icons/favicon.ico"/>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css">
    <style>
        body {
            background: black;
            color: white;
            text-align: center;
            height: 100vh;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            overflow: hidden;
            font-family: 'Poppins', sans-serif;
            position: relative;
        }
        h1 {
            font-size: 4rem;
            font-weight: bold;
            text-shadow: 3px 3px 10px rgba(255,255,255,0.8);
        }
        p {
            font-size: 1.5rem;
            margin-bottom: 30px;
            text-shadow: 2px 2px 10px rgba(255,255,255,0.7);
        }
        .contact-btn {
            background: linear-gradient(145deg, #00d2ff, #3a7bd5);
            color: white;
            padding: 15px 30px;
            font-size: 20px;
            border: none;
            border-radius: 50px;
            transition: transform 0.3s ease, background 0.3s ease;
            box-shadow: 0 4px 10px rgba(0,0,0,0.2);
        }
        .contact-btn:hover {
            background: linear-gradient(145deg, #3a7bd5, #00d2ff);
            transform: scale(1.1);
        }
        .snake {
            position: absolute;
            width: 20px;
            height: 20px;
            background-color: transparent;
            border: 2px solid white;
            border-radius: 50%;
            box-shadow: 0 0 10px rgba(255, 255, 255, 0.8);
        }
    </style>
</head>
<body>
    <h1>Coming Soon</h1>
    <p>Our website is under maintenance. Stay tuned!</p>
    <button class="contact-btn" onclick="window.location.href='https://wa.me/919600849617';">Contact Us</button>
    
    <script>
        let snakeBody = [];
        let snakeLength = 20;
        let delay = 200; // Increased delay to slow down movement
        
        for (let i = 0; i < snakeLength; i++) {
            let segment = document.createElement("div");
            segment.classList.add("snake");
            document.body.appendChild(segment);
            snakeBody.push(segment);
        }
        
        document.addEventListener("mousemove", (event) => {
            let mouseX = event.clientX;
            let mouseY = event.clientY;
            
            snakeBody.forEach((segment, index) => {
                setTimeout(() => {
                    segment.style.left = mouseX + "px";
                    segment.style.top = mouseY + "px";
                }, index * delay);
            });
        });
    </script>
</body>
</html>
