<style>
  /* General Styling */
  body {
    font-family: 'Inter', sans-serif;
    background-color: #f7f9fc;
    color: #333333;
  }

  

  /* Tab and Search Styling */
  .nav-tabs {
    border-bottom: 1px solid #ddd;
    margin-bottom: 20px;
  }

  .custom-search .form-inline {
    display: flex;
  }

  .form-control {
    border-radius: 6px;
    border: 1px solid #ddd;
  }

  .btn-default {
    background-color: #f0f0f0;
    color: #333;
    border: 1px solid #ccc;
    border-radius: 6px;
    padding: 6px 12px;
    font-size: 0.85em;
  }

  .btn-default:hover {
    background-color: #e9ecef;
  }

  /* Panel and Table Styling */
  .panel-default {
    background-color: #ffffff;
    border: 1px solid #ddd;
    border-radius: 8px;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
  }

  .panel-heading {
    background-color: #f7f9fc;
    color: #333;
    font-weight: bold;
    padding: 15px;
    border-bottom: 1px solid #ddd;
  }

  .table-responsive {
    margin-top: 20px;
  }

  .table-striped {
    width: 100%;
    margin-bottom: 1rem;
    border-collapse: collapse;
  }

  .table-striped th, .table-striped td {
    padding: 12px;
    vertical-align: middle;
  }

  .table-striped thead th {
    background-color: #f0f4f8;
    font-weight: 600;
  }

  .table-striped tbody tr:hover {
    background-color: #f9f9f9;
  }

  /* Checkboxes and Actions */
  .checkAll-holder {
    display: flex;
    align-items: center;
  }

  .dropdown-menu {
    min-width: 150px;
  }

  /* Pagination Styling */
  .pagination {
    margin: 0;
    padding: 0;
  }

  .pagination li a {
    padding: 6px 12px;
    color: #333;
    border: 1px solid #ddd;
    border-radius: 4px;
  }

  .pagination li.active a {
    background-color: #007bff;
    color: #fff;
    border-color: #007bff;
  }

  /* Modal Styling */
  .modal-content {
    border-radius: 8px;
  }

  .modal-body h4 {
    font-size: 1.2em;
  }
  /* Import Google Fonts */
@import url("//fonts.googleapis.com/css2?family=Inter:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap");

/* Body */
body{
 font-family:'Inter', sans-serif;
}

/* Button */
.input-group .search-select-wrap .btn{
 min-height:34px;
}

/* Panel heading */
.col-lg-12 .panel .panel-heading{
 font-weight:600;
 font-size:14px;
}

/* Th */
.table-striped tr th{
 font-size:14px;
 text-transform:uppercase;
}

/* Table Data */
.table-striped tr td{
 font-size:14px;
 text-transform:capitalize;
}

/* Link */
.table-striped td a{
 color:#c11431;
}

/* List Item */
.action-block .action-list > li:nth-child(1){
 text-transform:capitalize;
}

/* List */
.action-list li ul{
 transform:translatex(0px) translatey(0px);
}

/* Link */
.action-list li a{
 text-transform:capitalize;
}

/* Import Google Fonts */
@import url("//fonts.googleapis.com/css2?family=Inter:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap");

/* Th */
.table-striped tr th{
 text-align:center;
 font-family:'Inter';
}

/* Table Data */
.table-striped tr td{
 text-align:center;
 font-family:'Inter', sans-serif;
}

/* Panel heading */
.col-lg-12 .panel .panel-heading{
 font-family:'Inter', sans-serif;
 text-align:center;
 text-transform:uppercase;
}
/* Action list */
.checkAll-th .action-block .action-list{
 top:1px;
 height:23px;
}

/* Button */
.action-list li .btn-xs-caret{
 background-color:rgba(255,255,255,0);
}



/* Panel heading */
.col-lg-12 .panel .panel-heading{
 font-size:18px;
}
/* Input */
.form-inline .input-group input[type=text]{
 background-color: #e9ecef; /* Light input background */
    border-radius: 8px;
    padding: 12px;
    color: #333; /* Dark text color */
    box-shadow: inset 0 2px 4px rgba(0, 0, 0, 0.1);
    min-height: 50px;
}


/* Select */
.input-group .search-select-wrap select{
 background-color: #e9ecef; /* Light input background */
    border-radius: 8px;
    padding: 12px;
    color: #333; /* Dark text color */
    box-shadow: inset 0 2px 4px rgba(0, 0, 0, 0.1);
    min-height: 50px;
}


/* Button */
.input-group .search-select-wrap .btn{
 background-color: #e9ecef; /* Light input background */
    border-radius: 8px;
    padding: 12px;
    color: #333; /* Dark text color */
    box-shadow: inset 0 2px 4px rgba(0, 0, 0, 0.1);
    min-height: 50px;
}
.search-select-wrap:before{
    display:none !important;
}

/* Input */
.form-inline .input-group input[type=text]{
 border-top-right-radius:0px;
 border-bottom-right-radius:0px;
}

/* Select */
.input-group .search-select-wrap select{
 border-top-left-radius:0px;
 border-bottom-left-radius:0px;
}





</style>


<?php include 'header.php'; ?>
<div class="container-fluid">

  <ul class="nav nav-tabs">
     <li class="pull-right custom-search">
        <form class="form-inline" action="<?=site_url("admin/logs")?>" method="get">
           <div class="input-group">
              <input type="text" name="search" class="form-control" value="<?=$search_word?>" placeholder="Search">
              <span class="input-group-btn search-select-wrap">
                 <select class="form-control search-select" name="search_type">
                    <option value="username" <?php if( $search_where == "username" ): echo 'selected'; endif; ?> >Username</option>
                    <option value="action" <?php if( $search_where == "action" ): echo 'selected'; endif; ?> >Action</option>
                 </select>
                 <button type="submit" class="btn btn-default"><span class="fa fa-search" aria-hidden="true"></span></button>
              </span>
           </div>
        </form>
     </li>
  </ul>

   <div class="row">
      <div class="col-lg-12">
         <div class="panel panel-default">
            <div class="panel-heading">
              Updated Logs
            </div>
            <!-- /.panel-heading -->
            <div class="panel-body">
               <div class="table-responsive">
                  <table class="table table-striped">
                     <thead>
                        <tr>
                          <th class="checkAll-th">
                             <div class="checkAll-holder">
                                <input type="checkbox" id="checkAll">
                                <input type="hidden" id="checkAllText" value="order">
                             </div>
                             <div class="action-block">
                                <ul class="action-list" style="margin:5px 0 0 0!important">
                                   <li><span class="countlogs"></span> Selected Logs</li>
                                   <li>
                                      <div class="dropdown">
                                         <button type="button" class="btn btn-default btn-xs dropdown-toggle btn-xs-caret" data-toggle="dropdown"> Batch Operations <span class="caret"></span></button>
                                         <ul class="dropdown-menu">
                                            <li>
                                              <a class="bulkorder" data-type="delete">Delete</a>
                                            </li>
                                         </ul>
                                      </div>
                                   </li>
                                </ul>
                             </div>
                          </th>
                           <th>Id</th>
                           <th>Service Id</th>
                         
<th>Action</th>
<th>Description</th>
                           <th>Date</th>
                           

                        </tr>
                     </thead>
                     <form id="changebulkForm" action="<?php echo site_url("admin/updates/multi-action") ?>" method="post">
                       <tbody>
                         <?php if( !$logs ): ?>
                           <tr>
                             <td colspan="7"><center>No logs found</center></td>
                           </tr>
                         <?php endif; ?>
                         <?php foreach($logs as $log): ?>
                          <tr>
                            <td><input type="checkbox" class="selectOrder" name="log[<?php echo $log["u_id"] ?>]" value="1" style="border:1px solid #fff"></td>
                             <td><?php echo $log["u_id"] ?></td>
                             <td><?php echo $log["service_id"] ?></td>
<td><?php echo $log["action"] ?></td>
                             <td><?php echo $log["description"] ?></td>
                             <td><?php echo $log["date"] ?></td>
                             
                          </tr>
                        <?php endforeach; ?>
                       </tbody>
                       <input type="hidden" name="bulkStatus" id="bulkStatus" value="0">
                     </form>
                  </table>
               </div>
            </div>
         </div>
         <?php if( $paginationArr["count"] > 1 ): ?>
           <div class="row">
              <div class="col-sm-8">
                 <nav>
                    <ul class="pagination">
                      <?php if( $paginationArr["current"] != 1 ): ?>
                       <li class="prev"><a href="<?php echo site_url("admin/updates/1/".$search_link) ?>">&laquo;</a></li>
                       <li class="prev"><a href="<?php echo site_url("admin/updates/".$paginationArr["previous"]."/".$search_link) ?>">&lsaquo;</a></li>
                       <?php
                           endif;
                           for ($page=1; $page<=$pageCount; $page++):
                             if( $page >= ($paginationArr['current']-9) and $page <= ($paginationArr['current']+9) ):
                       ?>
                       <li class="<?php if( $page == $paginationArr["current"] ): echo "active"; endif; ?> "><a href="<?php echo site_url("admin/updates/".$page."/".$status.$search_link) ?>"><?=$page?></a></li>
                       <?php endif; endfor;
                             if( $paginationArr["current"] != $paginationArr["count"] ):
                       ?>
                       <li class="next"><a href="<?php echo site_url("admin/updates/".$paginationArr["next"]."/".$search_link) ?>" data-page="1">&rsaquo;</a></li>
                       <li class="next"><a href="<?php echo site_url("admin/updates/".$paginationArr["count"]."/".$search_link) ?>" data-page="1">&raquo;</a></li>
                       <?php endif; ?>
                    </ul>
                 </nav>
              </div>
           </div>
         <?php endif; ?>
      </div>
   </div>
</div>

<div class="modal modal-center fade" id="confirmChange" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static">
   <div class="modal-dialog modal-dialog-center" role="document">
      <div class="modal-content">
         <div class="modal-body text-center">
            <h4>Are you sure you want to take action ?</h4>
            <div align="center">
               <a class="btn btn-primary" href="" id="confirmYes">Yes</a>
               <button type="button" class="btn btn-default" data-dismiss="modal">No</button>
            </div>
         </div>
      </div>
   </div>
</div>
<?php include 'footer.php'; ?>
