<?php include 'new-header.php'; ?>
<style>
/* General styles for responsive layout */
body {
    
    margin: 0; /* Remove default margin */
    padding: 0; /* Remove default padding */
    height: 100%; /* Ensure full height for body */
    touch-action: pan-down; /* Allow only upward scrolling for refresh on mobile devices */
}

html, body {
    width: 100%; /* Ensure full width */
    scroll-behavior: smooth; /* Smooth scrolling for better user experience */
}

/* Container */
.container {
    background-color: #f8f9fa; /* Light background */
    display: flex;
    justify-content: center; /* Center content horizontally */
    align-items: flex-start; /* Align content to the top for better fit */
    min-height: 100vh; /* Ensure the container takes the full viewport height */
    padding: 20px; /* Add padding for small screens */
    box-sizing: border-box; /* Include padding in width/height calculations */
}

/* Category List Div */
.category-list-div {
    background-color: #ffffff; /* White background for the list */
    border-radius: 5px; /* Rounded corners for the list container */
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1); /* Subtle shadow for elevation */
    padding: 20px; /* Padding inside the list */
    width: 100%; /* Make it fit the container width */
    max-width: 600px; /* Limit maximum width */
}

/* List Items */
.list-group-item {
    border: none; /* Remove border for list items */
    padding: 15px; /* Increased padding for list items */
    font-size: 1.1em; /* Larger font size for better readability */
    color: #333; /* Dark text color */
    transition: background-color 0.3s; /* Smooth background color transition */
}

.list-group-item:hover {
    background-color: #f1f1f1; /* Light gray on hover */
}

.list-group-item.active {
    background-color: #007bff; /* Blue background for active items */
    color: #ffffff; /* White text for active items */
}

/* Header Title */
.header-title {
    font-size: 1.8em; /* Title size */
    font-weight: bold; /* Bold title */
    margin-bottom: 15px; /* Space below title */
    color: #007bff; /* Blue color for the title */
    text-align: center; /* Center the title */
}

/* Media Queries for Responsiveness */
@media (max-width: 576px) {
    .header-title {
        font-size: 1.5em; /* Smaller title for extra small screens */
    }

    .list-group-item {
        font-size: 1em; /* Adjust font size for smaller screens */
    }
}

@media (min-width: 576px) and (max-width: 768px) {
    .header-title {
        font-size: 1.6em; /* Medium title for small screens */
    }
}

@media (min-width: 768px) {
    .header-title {
        font-size: 1.8em; /* Standard title size for medium and larger screens */
    }
}

/* Category List Positioning */
.container .category-list-div {
    position: relative;
    top: 0; /* Remove fixed offset to fit content dynamically */
}

/* Prevent scrolling down and enable upward pull for refresh */
body::before {
    content: "";
    display: block;
    height: 1px; /* Adds a minimal height element to trigger pull-to-refresh */
}
@media (max-width:767px){

 /* Body */
 body{
  overflow-x:hidden;
 }
 * Column 8/12 */
 .container .category-list-div{
  overflow-x:hidden;
 }
}
</style>

<div class="container margin-top-container">
    <div class="row justify-content-center"> <!-- Center the row for small screens -->
        <div class="col-lg-8 col-md-10 col-12 category-list-div"> <!-- Responsive column sizes -->
            <ul id="category-list" class="list-group col">
                <?=$list?>
            </ul>
        </div>
    </div>
</div>

<?php include "new-footer.php"; ?>
