<style>
  /* Light Theme Styles */
  body {
    font-family: 'Inter', sans-serif;
    background-color: #f7f9fc;
    color: #333333;
  }

  /* Panel Styling */
  .panel {
    border: none;
    background-color: #ffffff;
    border-radius: 8px;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
  }

  .panel-body {
    padding: 20px;
  }

  /* Form Label and Input Styling */
  .form-group label {
    font-weight: 600;
    color: #555555;
    margin-bottom: 8px;
    display: block;
  }

  .form-control {
   display: flex;
    align-items: center;
    background-color: #e9ecef; /* Light input background */
    border-radius: 8px;
    padding: 12px;
    color: #333; /* Dark text color */
    box-shadow: inset 0 2px 4px rgba(0, 0, 0, 0.1);
    min-height: 50px;
}

  .form-control:focus {
    border-color: #007bff;
    background-color: #ffffff;
  }

  /* Button Styling */
  .btn-primary {
      width:100%;
    background: linear-gradient(145deg, #007bff, #0056b3); /* Light gradient */
    color: #ffffff;
    padding: 14px 28px;
    font-size: 14px;
    font-weight: 500;
    border: none;
    border-radius: 5px;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    transition: background 0.3s ease, transform 0.2s ease;
}

  .btn-primary:hover {
    background: linear-gradient(145deg, #0056b3, #003c82);
    transform: translateY(-2px);
}
</style>
<div class="col-md-8">
  <div class="panel panel-default">
    <div class="panel-body">
      <form action="" method="post" enctype="multipart/form-data">
        
        <!-- SEO Title -->
        <div class="form-group">
          <label for="seo-title" class="control-label">Title for Site Appearance on Google</label>
          <input type="text" id="seo-title" class="form-control" name="seo" value="<?=$settings["site_seo"]?>">
        </div>
        
        <!-- Site Title -->
        <div class="form-group">
          <label for="site-title" class="control-label">Site Title</label>
          <input type="text" id="site-title" class="form-control" name="title" value="<?=$settings["site_title"]?>">
        </div>
        
        <!-- Site Keywords -->
        <div class="form-group">
          <label for="site-keywords" class="control-label">Site Keywords</label>
          <input type="text" id="site-keywords" class="form-control" name="keywords" value="<?=$settings["site_keywords"]?>">
        </div>
        
        <!-- Site Description -->
        <div class="form-group">
          <label for="site-description" class="control-label">Site Description</label>
          <textarea id="site-description" class="form-control" rows="3" name="description"><?=$settings["site_description"]?></textarea>
        </div>
        
        <!-- Submit Button -->
        <button type="submit" class="btn btn-primary">Update Settings</button>
        
      </form>
    </div>
  </div>
</div>
